function [d, der] = calc_d(dl1, dl2)
% Calculates the normalized transition width d based on Eq. (21) in J.
% Pauly's IEEE 1991 paper.
% Input: In slice/out slice ripples dl1 and dl2.
% 02-March-2001, Yuval Zur.
% 30-December-2001: der = d(d)/d(dl1) added.
% +++++++++++++++++++++++++++++++++++++++++++++++++++
l1 = log10(dl1); w = log10(dl2/dl1);
a1 = 5.309e-3; a2 = 7.114e-2; a3 = -0.4761;
a4 = -2.66e-3; a5 = -0.5941; a6 = -0.4278;
d = (a1*l1^2 + a2*l1 + a3)*(w + l1) + a4*l1^2 + a5*l1 + a6;
der = (3*a1*l1^2 + (a1*w + a2 + a4)*2*l1 + a2*w + a3 + a5)/(2.3026*dl1);
